/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import java.util.GregorianCalendar;

public class Config {
    private static String treeTagger = "C:\\TreeTagger\\";
    private static String baseName = "baseipri20110221b_em";
    private static String baseURL = "127.0.0.1";
    private static String login = "root";
    private static String pass = "";
    private static File ieCapt = new File("IECapt.exe");
    private static String captures = "cap";
    private static String classification = "svm";
    private static long dateDebut = 0;

    static{
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(GregorianCalendar.YEAR, 2009);
        cal.set(GregorianCalendar.MONTH, GregorianCalendar.OCTOBER);
        cal.set(GregorianCalendar.DAY_OF_MONTH, 1);
        cal.set(GregorianCalendar.HOUR_OF_DAY, 0);
        cal.set(GregorianCalendar.MINUTE, 0);
        cal.set(GregorianCalendar.SECOND, 0);
        dateDebut = cal.getTimeInMillis();
        
        File f = new File("Parametres.ini");
        if(!(f.exists())){
            try{
                f.createNewFile();
                FileWriter w = new FileWriter(f);
                w.write("# Repertoire d'installation de TreeTagger\r\n");
                w.write("ttdir=C:\\TreeTagger\\\r\n");
                w.write("# URL de la base de donnees\r\n");
                w.write("baseURL=127.0.0.1\r\n");
                w.write("# Nom de la base de donnees\r\n");
                w.write("basename=baseipri\r\n");
                w.write("# Identifiant IPRI pour la base de donnees\r\n");
                w.write("login=root\r\n");
                w.write("# Mot de passe IPRI pour la base de donnees\r\n");
                w.write("pass=\r\n");
                w.write("# Emplacement de l'utilitaire IECapt.exe (pour les captures d'ecran)\r\n");
                w.write("IECapt=IECapt.exe\r\n");
                w.write("# Répertoire ou stocker les captures d'ecran\r\n");
                w.write("capdir=cap\r\n");
                w.write("# Répertoire de svm multiclass\r\n");
                w.write("svmdir=svm\r\n");
                w.write("# Date minimale a prendre en compte lors de la collecte" +
                        " (JOUR-MOIS-ANNEE HEURE:MINUTE:SECONDE)\r\n");
                w.write("dateDebut=01-01-2010 00:00:00\r\n");
                w.flush();
                w.close();
            } catch(IOException ioe){

            }
        }
        try{
            BufferedReader r = new BufferedReader(new FileReader(f));
            while(r.ready()){
                String s = r.readLine();
                String[] ss = s.split("=");
                if(ss[0].trim().equals("ttdir")){
                    treeTagger = ss[1].trim();
                    //System.err.println("ttdir:"+ss[1].trim());
                }
                if(ss[0].trim().equals("basename")){
                    baseName = ss[1].trim();
                    //System.err.println("basename:"+ss[1].trim());
                }
                if(ss[0].trim().equals("baseURL")){
                    baseURL = ss[1].trim();
                    //System.err.println("baseURL:"+ss[1].trim());
                }
                if(ss[0].trim().equals("login")){
                    login = ss[1].trim();
                    //System.err.println("login:"+ss[1].trim());
                }
                if(ss[0].trim().equals("pass")){
                    pass = ss[1].trim();
                    //System.err.println("pass:"+ss[1].trim());
                }
                if(ss[0].trim().equals("IECapt")){
                    ieCapt = new File(ss[1].trim());
                    //System.err.println("IECapt:"+ss[1].trim());
                }
                if(ss[0].trim().equals("capdir")){
                    captures = ss[1].trim();
                    //System.err.println("capdir:"+ss[1].trim());
                }
                if(ss[0].trim().equals("svmdir")){
                    classification = ss[1].trim();
                }
                if(ss[0].trim().equals("dateDebut")){
                    String[] date0 = ss[1].trim().split(" ");
                    String[] date1 = date0[0].trim().split("-");
                    String[] date2 = date0[1].trim().split(":");
                    cal = new GregorianCalendar();
                    cal.set(GregorianCalendar.HOUR_OF_DAY, Integer.parseInt(date2[0].trim()));
                    cal.set(GregorianCalendar.MINUTE, Integer.parseInt(date2[1].trim()));
                    cal.set(GregorianCalendar.SECOND, Integer.parseInt(date2[2].trim()));
                    cal.set(GregorianCalendar.DAY_OF_MONTH, Integer.parseInt(date1[0].trim()));
                    cal.set(GregorianCalendar.MONTH, Integer.parseInt(date1[1].trim())-1);
                    cal.set(GregorianCalendar.YEAR, Integer.parseInt(date1[2].trim()));
                    dateDebut = cal.getTimeInMillis();
                    //System.err.println("dateDebut:"+cal.getTimeInMillis());
                }
            }
        } catch(IOException ioe){

        }
    }

    public static String getBaseName(){
        return baseName;
    }

    public static String getBaseURL(){
        return baseURL;
    }

    public static String getBaseLogin(){
        return login;
    }

    public static String getBasePassword(){
        return pass;
    }

    public static String getTreeTaggerDirectory(){
        return treeTagger;
    }

    public static File getCaptureProgram(){
        return ieCapt;
    }

    public static String getCaptureDirectory(){
        return captures;
    }

    public static String getClassificationDirectory(){
        return classification;
    }

    public static long getDateDepartCorpus(){
        return dateDebut;
    }
}
